% copyright 1999 by Gerrit Jahn, look at README for further details.

set terminal latex
set output "boltzman.tex"
set size 4.0/5, 2.0/3
set title "Boltzmann'sche $e$-Funktion"
set xlabel "$N=$Gesamtzahl aller Teilchen"
set xtics ("$\varepsilon_i$" 5.0 )
set ytics ("$N$" 1.5 )
set arrow from 0.0,0.0 to 0.0,1.48
set label "Gleichverteilung $(T=\infty)$" at 2.3,0.40
set arrow from -0.7,0.8 to -0.01,1.275
set label "$T=0$" at -1.0,0.72
set arrow from 1.3,1.0 to 0.6,0.6
set label "$0<T<\infty$" at 0.8,1.07
set nokey 
plot [0.0:5.0] [0.0:1.5] exp(-x) with lines 1,\
 0.30 with lines 4 