set terminal latex
set output "folgreak.tex"
set size 3.2/5.0, 1.7/3.0
set title "\small Folgereaktion"
set xtics ("$0$" 0.0, "$t_{B_{max}}$" 0.7846634)
set ytics ("$[A]_0$" 1.0)
set key 3.5,0.7 
set label "$C$" at -0.15,1.15 
set label "$t$" at 5.1,-0.1 
plot [0.0:5.0] [0.0:1.1]  -1.6*(exp(-2.0*x)-exp(-0.75*x)) \
 title "\scriptsize $[B]$" with lines 3, \
 1.0*exp(-2.0*x) title "\scriptsize $[A]$" with lines 1,\
 1.0-(-1.6*(exp(-2.0*x)-exp(-0.75*x)))-\
 (1.0*exp(-2.0*x)) title "\scriptsize $[C]$" with lines 4
                           